/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.elytratrims.common.access;

import dev.kikugie.elytratrims.common.access.BannerLayer;
import dev.kikugie.elytratrims.common.access.IFeatureAccess;
import dev.kikugie.elytratrims.common.util.ColorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\n\u001a\u00020\t*\u00020\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\u000e\u001a\u00020\r*\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\r*\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\t*\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u000bJ\u001b\u0010\u0014\u001a\u00020\r*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\r*\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0011J\u0013\u0010\u0018\u001a\u00020\u0017*\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\r*\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0011J\u0013\u0010\u001b\u001a\u00020\r*\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u0011J\u0013\u0010\u001c\u001a\u00020\u0017*\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u0019J\u0013\u0010\u001d\u001a\u00020\r*\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u0011J\u0013\u0010\u001e\u001a\u00020\r*\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u0011J\u0013\u0010\u001f\u001a\u00020\u0017*\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001f\u0010\u0019J\u0013\u0010 \u001a\u00020\r*\u00020\u0004H\u0016\u00a2\u0006\u0004\b \u0010\u0011J\u0013\u0010!\u001a\u00020\r*\u00020\u0004H\u0016\u00a2\u0006\u0004\b!\u0010\u0011\u00a8\u0006\""}, d2={"Ldev/kikugie/elytratrims/common/access/FeatureAccess;", "Ldev/kikugie/elytratrims/common/access/IFeatureAccess;", "<init>", "()V", "Lnet/minecraft/world/item/ItemStack;", "", "Ldev/kikugie/elytratrims/common/access/BannerLayer;", "getPatterns", "(Lnet/minecraft/world/item/ItemStack;)Ljava/util/List;", "", "getBaseColor", "(Lnet/minecraft/world/item/ItemStack;)I", "source", "", "setPatterns", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)V", "removePatterns", "(Lnet/minecraft/world/item/ItemStack;)V", "getColor", "color", "setColor", "(Lnet/minecraft/world/item/ItemStack;I)V", "removeColor", "", "hasGlow", "(Lnet/minecraft/world/item/ItemStack;)Z", "addGlow", "removeGlow", "getAnimationStatus", "addAnimationStatus", "removeAnimationStatus", "hasCosmicEffect", "addCosmicEffect", "removeCosmicEffect", "elytratrims-neoforge"})
@SourceDebugExtension(value={"SMAP\nFeatureAccess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureAccess.kt\ndev/kikugie/elytratrims/common/access/FeatureAccess\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n1563#2:185\n1634#2,3:186\n*S KotlinDebug\n*F\n+ 1 FeatureAccess.kt\ndev/kikugie/elytratrims/common/access/FeatureAccess\n*L\n92#1:185\n92#1:186,3\n*E\n"})
public final class FeatureAccess
implements IFeatureAccess {
    @NotNull
    public static final FeatureAccess INSTANCE = new FeatureAccess();

    private FeatureAccess() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<BannerLayer> getPatterns(@NotNull ItemStack $this$getPatterns) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$getPatterns, (String)"<this>");
        Object object = (BannerPatternLayers)$this$getPatterns.get(DataComponents.BANNER_PATTERNS);
        if (object != null && (object = object.layers()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BannerPatternLayers.Layer layer = (BannerPatternLayers.Layer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Holder holder = it.pattern();
                Intrinsics.checkNotNullExpressionValue((Object)holder, (String)"pattern(...)");
                DyeColor dyeColor = it.color();
                Intrinsics.checkNotNullExpressionValue((Object)dyeColor, (String)"color(...)");
                collection.add(new BannerLayer((Holder<BannerPattern>)holder, dyeColor));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public int getBaseColor(@NotNull ItemStack $this$getBaseColor) {
        Intrinsics.checkNotNullParameter((Object)$this$getBaseColor, (String)"<this>");
        Item item = $this$getBaseColor.getItem();
        BannerItem bannerItem = item instanceof BannerItem ? (BannerItem)item : null;
        return bannerItem != null && (bannerItem = bannerItem.getColor()) != null ? ColorKt.toArgb$default((DyeColor)bannerItem, 0, 1, null) : 0;
    }

    @Override
    public void setPatterns(@NotNull ItemStack $this$setPatterns, @NotNull ItemStack source) {
        Intrinsics.checkNotNullParameter((Object)$this$setPatterns, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        $this$setPatterns.applyComponents(source.getComponents().filter(FeatureAccess::setPatterns$lambda$0));
    }

    @Override
    public void removePatterns(@NotNull ItemStack $this$removePatterns) {
        Intrinsics.checkNotNullParameter((Object)$this$removePatterns, (String)"<this>");
        $this$removePatterns.remove(DataComponents.BANNER_PATTERNS);
    }

    @Override
    public int getColor(@NotNull ItemStack $this$getColor) {
        Intrinsics.checkNotNullParameter((Object)$this$getColor, (String)"<this>");
        return DyedItemColor.getOrDefault((ItemStack)$this$getColor, (int)0);
    }

    @Override
    public void setColor(@NotNull ItemStack $this$setColor, int color) {
        Intrinsics.checkNotNullParameter((Object)$this$setColor, (String)"<this>");
        $this$setColor.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(color, true));
    }

    @Override
    public void removeColor(@NotNull ItemStack $this$removeColor) {
        Intrinsics.checkNotNullParameter((Object)$this$removeColor, (String)"<this>");
        $this$removeColor.remove(DataComponents.DYED_COLOR);
    }

    @Override
    public boolean hasGlow(@NotNull ItemStack $this$hasGlow) {
        Intrinsics.checkNotNullParameter((Object)$this$hasGlow, (String)"<this>");
        CustomData customData = (CustomData)$this$hasGlow.get(DataComponents.CUSTOM_DATA);
        return customData != null && (customData = customData.getUnsafe()) != null ? customData.getBoolean("glow") : false;
    }

    @Override
    public void addGlow(@NotNull ItemStack $this$addGlow) {
        Intrinsics.checkNotNullParameter((Object)$this$addGlow, (String)"<this>");
        CustomData customData = (CustomData)$this$addGlow.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            customData = CustomData.EMPTY;
        }
        CompoundTag data = customData.copyTag();
        data.putBoolean("glow", true);
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)$this$addGlow, (CompoundTag)data);
    }

    @Override
    public void removeGlow(@NotNull ItemStack $this$removeGlow) {
        Intrinsics.checkNotNullParameter((Object)$this$removeGlow, (String)"<this>");
        CustomData customData = (CustomData)$this$removeGlow.get(DataComponents.CUSTOM_DATA);
        if (customData == null || (customData = customData.copyTag()) == null) {
            return;
        }
        CustomData data = customData;
        data.remove("glow");
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)$this$removeGlow, (CompoundTag)data);
    }

    @Override
    public boolean getAnimationStatus(@NotNull ItemStack $this$getAnimationStatus) {
        Intrinsics.checkNotNullParameter((Object)$this$getAnimationStatus, (String)"<this>");
        CustomData customData = (CustomData)$this$getAnimationStatus.get(DataComponents.CUSTOM_DATA);
        return customData != null && (customData = customData.getUnsafe()) != null ? customData.getBoolean("animation") : false;
    }

    @Override
    public void addAnimationStatus(@NotNull ItemStack $this$addAnimationStatus) {
        Intrinsics.checkNotNullParameter((Object)$this$addAnimationStatus, (String)"<this>");
        CustomData customData = (CustomData)$this$addAnimationStatus.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            customData = CustomData.EMPTY;
        }
        CompoundTag data = customData.copyTag();
        data.putBoolean("animation", true);
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)$this$addAnimationStatus, (CompoundTag)data);
    }

    @Override
    public void removeAnimationStatus(@NotNull ItemStack $this$removeAnimationStatus) {
        Intrinsics.checkNotNullParameter((Object)$this$removeAnimationStatus, (String)"<this>");
        CustomData customData = (CustomData)$this$removeAnimationStatus.get(DataComponents.CUSTOM_DATA);
        if (customData == null || (customData = customData.copyTag()) == null) {
            return;
        }
        CustomData data = customData;
        data.remove("animation");
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)$this$removeAnimationStatus, (CompoundTag)data);
    }

    @Override
    public boolean hasCosmicEffect(@NotNull ItemStack $this$hasCosmicEffect) {
        Intrinsics.checkNotNullParameter((Object)$this$hasCosmicEffect, (String)"<this>");
        CustomData customData = (CustomData)$this$hasCosmicEffect.get(DataComponents.CUSTOM_DATA);
        return customData != null && (customData = customData.getUnsafe()) != null ? customData.getBoolean("gateway") : false;
    }

    @Override
    public void addCosmicEffect(@NotNull ItemStack $this$addCosmicEffect) {
        Intrinsics.checkNotNullParameter((Object)$this$addCosmicEffect, (String)"<this>");
        CustomData customData = (CustomData)$this$addCosmicEffect.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            customData = CustomData.EMPTY;
        }
        CompoundTag data = customData.copyTag();
        data.putBoolean("gateway", true);
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)$this$addCosmicEffect, (CompoundTag)data);
    }

    @Override
    public void removeCosmicEffect(@NotNull ItemStack $this$removeCosmicEffect) {
        Intrinsics.checkNotNullParameter((Object)$this$removeCosmicEffect, (String)"<this>");
        CustomData customData = (CustomData)$this$removeCosmicEffect.get(DataComponents.CUSTOM_DATA);
        if (customData == null || (customData = customData.copyTag()) == null) {
            return;
        }
        CustomData data = customData;
        data.remove("gateway");
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)$this$removeCosmicEffect, (CompoundTag)data);
    }

    private static final boolean setPatterns$lambda$0(DataComponentType it) {
        return Intrinsics.areEqual((Object)it, (Object)DataComponents.BANNER_PATTERNS);
    }
}

