/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.fabric.citresewn.defaults.cit.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7923;
import shcm.shsupercm.fabric.citresewn.api.CITTypeContainer;
import shcm.shsupercm.fabric.citresewn.cit.CIT;
import shcm.shsupercm.fabric.citresewn.cit.CITCache;
import shcm.shsupercm.fabric.citresewn.cit.CITCondition;
import shcm.shsupercm.fabric.citresewn.cit.CITContext;
import shcm.shsupercm.fabric.citresewn.cit.CITParsingException;
import shcm.shsupercm.fabric.citresewn.cit.CITType;
import shcm.shsupercm.fabric.citresewn.defaults.cit.conditions.ConditionItems;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyGroup;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyKey;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyValue;

public class TypeArmor
extends CITType {
    public static final Container CONTAINER = new Container();
    public final Map<String, class_2960> textures = new HashMap<String, class_2960>();

    public Set<PropertyKey> typeProperties() {
        return Set.of(PropertyKey.of((String)"texture"));
    }

    public void load(List<CITCondition> conditions, PropertyGroup properties, class_3300 resourceManager) throws CITParsingException {
        boolean itemsConditionPresent = false;
        for (CITCondition condition : conditions) {
            if (!(condition instanceof ConditionItems)) continue;
            ConditionItems conditionItems = (ConditionItems)condition;
            for (class_1792 item : conditionItems.items) {
                if (!(item instanceof class_1738)) {
                    throw new CITParsingException("This type only accepts armor items for the items condition", properties, -1);
                }
                itemsConditionPresent = true;
            }
        }
        if (!itemsConditionPresent) {
            try {
                class_2960 propertiesName = class_2960.method_12829((String)properties.stripName());
                if (!class_7923.field_41178.method_10250(propertiesName)) {
                    throw new Exception();
                }
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(propertiesName);
                if (!(item instanceof class_1738)) {
                    throw new Exception();
                }
                conditions.add((CITCondition)new ConditionItems(item));
            }
            catch (Exception ignored) {
                throw new CITParsingException("Not targeting any item type", properties, -1);
            }
        }
        for (PropertyValue propertyValue : properties.get("citresewn", new String[]{"texture"})) {
            class_2960 identifier = TypeArmor.resolveAsset((class_2960)properties.identifier, (PropertyValue)propertyValue, (String)"textures", (String)".png", (class_3300)resourceManager);
            if (identifier == null) {
                throw new CITParsingException("Could not resolve texture", properties, propertyValue.position());
            }
            this.textures.put(propertyValue.keyMetadata(), identifier);
        }
        if (this.textures.size() == 0) {
            throw new CITParsingException("Texture not specified", properties, -1);
        }
    }

    public static class Container
    extends CITTypeContainer<TypeArmor> {
        public final List<BiFunction<class_1309, class_1304, class_1799>> getItemInSlotCompatRedirects = new ArrayList<BiFunction<class_1309, class_1304, class_1799>>();
        public Set<CIT<TypeArmor>> loaded = new HashSet<CIT<TypeArmor>>();
        public Map<class_1738, Set<CIT<TypeArmor>>> loadedTyped = new IdentityHashMap<class_1738, Set<CIT<TypeArmor>>>();

        public Container() {
            super(TypeArmor.class, TypeArmor::new, "armor");
        }

        public void load(List<CIT<TypeArmor>> parsedCITs) {
            this.loaded.addAll(parsedCITs);
            for (CIT<TypeArmor> cit : parsedCITs) {
                for (CITCondition condition : cit.conditions) {
                    if (!(condition instanceof ConditionItems)) continue;
                    ConditionItems items = (ConditionItems)condition;
                    for (class_1792 item : items.items) {
                        if (!(item instanceof class_1738)) continue;
                        class_1738 armorItem = (class_1738)item;
                        this.loadedTyped.computeIfAbsent(armorItem, i -> new LinkedHashSet()).add(cit);
                    }
                }
            }
        }

        public void dispose() {
            this.loaded.clear();
            this.loadedTyped.clear();
        }

        public CIT<TypeArmor> getCIT(CITContext context) {
            return (CIT)((CITCacheArmor)context.stack).citresewn$getCacheTypeArmor().get(context).get();
        }

        public CIT<TypeArmor> getRealTimeCIT(CITContext context) {
            if (!(context.stack.method_7909() instanceof class_1738)) {
                return null;
            }
            Set<CIT<TypeArmor>> loadedForItemType = this.loadedTyped.get(context.stack.method_7909());
            if (loadedForItemType != null) {
                for (CIT<TypeArmor> cit : loadedForItemType) {
                    if (!cit.test(context)) continue;
                    return cit;
                }
            }
            return null;
        }

        public class_1799 getVisualItemInSlot(class_1309 entity, class_1304 slot) {
            for (BiFunction<class_1309, class_1304, class_1799> redirect : this.getItemInSlotCompatRedirects) {
                class_1799 stack = redirect.apply(entity, slot);
                if (stack == null) continue;
                return stack;
            }
            return entity.method_6118(slot);
        }
    }

    public static interface CITCacheArmor {
        public CITCache.Single<TypeArmor> citresewn$getCacheTypeArmor();
    }
}

