/*
 * Decompiled with CFR 0.152.
 */
package de.tyrannus.cleandebug.mixin;

import de.tyrannus.cleandebug.CleanDebug;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DebugScreenOverlay.class}, priority=900)
public abstract class DebugHudMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @Inject(method={"drawText"}, at={@At(value="HEAD")})
    private void modifyDebugText(GuiGraphics context, List<String> text, boolean left, CallbackInfo ci) {
        if (left) {
            CleanDebug.modifyLeftText(text);
        } else {
            CleanDebug.modifyRightText(text);
        }
    }

    @Redirect(method={"getRightText"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/hit/HitResult;getType()Lnet/minecraft/util/hit/HitResult$Type;", ordinal=1))
    protected final HitResult.Type changeFluidHitType(HitResult result) {
        return CleanDebug.getFluidHitResultType(result, (Level)this.minecraft.level);
    }
}

