/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.mouse;

import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;

public class MouseHelper {
    public static double getMouseDistanceFromCenter(Window window) {
        double centerX = (double)window.getGuiScaledWidth() / 2.0;
        double centerY = (double)window.getGuiScaledHeight() / 2.0;
        Minecraft mc = Minecraft.getInstance();
        double posX = mc.mouseHandler.xpos() * (double)window.getGuiScaledWidth() / (double)window.getScreenWidth() - centerX;
        double posY = mc.mouseHandler.ypos() * (double)window.getGuiScaledHeight() / (double)window.getScreenHeight() - centerY;
        return Math.sqrt(posX * posX + posY * posY);
    }

    public static float getMouseAngleFromCenter(Window window) {
        double centerX = (double)window.getGuiScaledWidth() / 2.0;
        double centerY = (double)window.getGuiScaledHeight() / 2.0;
        Minecraft mc = Minecraft.getInstance();
        double posX = mc.mouseHandler.xpos() * (double)window.getGuiScaledWidth() / (double)window.getScreenWidth() - centerX;
        double posY = mc.mouseHandler.ypos() * (double)window.getGuiScaledHeight() / (double)window.getScreenHeight() - centerY;
        return (float)(Math.toDegrees(Math.atan2(posY, posX)) + 90.0 + 360.0) % 360.0f;
    }

    public static int getSelectedIndex(int count) {
        float angle = MouseHelper.getMouseAngleFromCenter(Minecraft.getInstance().getWindow());
        float segment = 360.0f / (float)count;
        float startSeg = segment / 2.0f;
        for (int i = 0; i < count; ++i) {
            if (angle < startSeg) {
                return i;
            }
            startSeg += segment;
        }
        return 0;
    }
}

