/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.fabric.citresewn.pack;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import shcm.shsupercm.fabric.citresewn.CITResewn;
import shcm.shsupercm.fabric.citresewn.api.CITGlobalProperties;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyGroup;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyKey;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyValue;

public class GlobalProperties
extends PropertyGroup {
    public GlobalProperties() {
        super("global_properties", ResourceLocation.fromNamespaceAndPath((String)"citresewn", (String)"global_properties"));
    }

    @Override
    public String getExtension() {
        return ".properties";
    }

    @Override
    public PropertyGroup load(String packName, ResourceLocation identifier, InputStream is) throws IOException, ResourceLocationException {
        PropertyGroup group = PropertyGroup.tryParseGroup(packName, identifier, is);
        if (group != null) {
            for (Map.Entry<PropertyKey, Set<PropertyValue>> entry : group.properties.entrySet()) {
                this.properties.computeIfAbsent(entry.getKey(), key -> new LinkedHashSet()).addAll((Collection)entry.getValue());
            }
        }
        return this;
    }

    public void callHandlers() {
        for (EntrypointContainer container : FabricLoader.getInstance().getEntrypointContainers("citresewn:global_property", CITGlobalProperties.class)) {
            String containerNamespace = container.getProvider().getMetadata().getId();
            if (containerNamespace.equals("citresewn-defaults")) {
                containerNamespace = "citresewn";
            }
            for (Map.Entry entry : this.properties.entrySet()) {
                if (!((PropertyKey)entry.getKey()).namespace().equals(containerNamespace)) continue;
                PropertyValue lastValue = null;
                Iterator iterator = ((Set)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    PropertyValue value;
                    lastValue = value = (PropertyValue)iterator.next();
                }
                try {
                    ((CITGlobalProperties)container.getEntrypoint()).globalProperty(((PropertyKey)entry.getKey()).path(), lastValue);
                }
                catch (Exception e) {
                    CITResewn.logErrorLoading((String)(lastValue == null ? "Errored while disposing global properties" : "Errored while parsing global properties: Line " + lastValue.position() + " of " + String.valueOf(lastValue.propertiesIdentifier()) + " in " + lastValue.packName()));
                    e.printStackTrace();
                }
            }
        }
    }
}

