/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.fabric.citresewn.defaults.cit.types;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import shcm.shsupercm.fabric.citresewn.api.CITGlobalProperties;
import shcm.shsupercm.fabric.citresewn.api.CITTypeContainer;
import shcm.shsupercm.fabric.citresewn.cit.CIT;
import shcm.shsupercm.fabric.citresewn.cit.CITCache;
import shcm.shsupercm.fabric.citresewn.cit.CITCondition;
import shcm.shsupercm.fabric.citresewn.cit.CITContext;
import shcm.shsupercm.fabric.citresewn.cit.CITParsingException;
import shcm.shsupercm.fabric.citresewn.cit.CITType;
import shcm.shsupercm.fabric.citresewn.defaults.cit.conditions.ConditionEnchantments;
import shcm.shsupercm.fabric.citresewn.defaults.config.CITResewnDefaultsConfig;
import shcm.shsupercm.fabric.citresewn.defaults.mixin.types.enchantment.RenderPhaseAccessor;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyGroup;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyKey;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyValue;
import shcm.shsupercm.util.logic.Loops;

public class TypeEnchantment
extends CITType {
    public static final Container CONTAINER = new Container();
    public ResourceLocation texture;
    public int layer;
    public float speed;
    public float rotation;
    public float duration;
    public float r;
    public float g;
    public float b;
    public float a;
    public boolean useGlint;
    public boolean blur;
    public Blend blend;
    public final Map<GlintRenderLayer, RenderType> renderLayers = new EnumMap<GlintRenderLayer, RenderType>(GlintRenderLayer.class);
    private final MergeMethodIntensity methodIntensity = new MergeMethodIntensity();
    private Set<ResourceLocation> enchantmentChecks = null;

    public Set<PropertyKey> typeProperties() {
        return Set.of(PropertyKey.of((String)"texture"), PropertyKey.of((String)"layer"), PropertyKey.of((String)"speed"), PropertyKey.of((String)"rotation"), PropertyKey.of((String)"duration"), PropertyKey.of((String)"r"), PropertyKey.of((String)"g"), PropertyKey.of((String)"b"), PropertyKey.of((String)"a"), PropertyKey.of((String)"useGlint"), PropertyKey.of((String)"blur"), PropertyKey.of((String)"blend"));
    }

    public void load(List<CITCondition> conditions, PropertyGroup properties, ResourceManager resourceManager) throws CITParsingException {
        PropertyValue textureProp = properties.getLastWithoutMetadata("citresewn", new String[]{"texture"});
        this.texture = TypeEnchantment.resolveAsset((ResourceLocation)properties.identifier, (PropertyValue)textureProp, (String)"textures", (String)".png", (ResourceManager)resourceManager);
        if (this.texture == null) {
            throw textureProp == null ? new CITParsingException("No texture specified", properties, -1) : new CITParsingException("Could not resolve texture", properties, textureProp.position());
        }
        PropertyValue layerProp = properties.getLastWithoutMetadataOrDefault("0", "citresewn", new String[]{"layer"});
        try {
            this.layer = Integer.parseInt(layerProp.value());
        }
        catch (Exception e) {
            throw new CITParsingException("Could not parse integer", properties, layerProp.position(), (Throwable)e);
        }
        this.speed = this.parseFloatOrDefault(0.0f, "speed", properties);
        this.rotation = this.parseFloatOrDefault(0.0f, "rotation", properties);
        this.duration = Math.max(0.0f, this.parseFloatOrDefault(0.0f, "duration", properties));
        this.r = Math.max(0.0f, this.parseFloatOrDefault(1.0f, "r", properties));
        this.g = Math.max(0.0f, this.parseFloatOrDefault(1.0f, "g", properties));
        this.b = Math.max(0.0f, this.parseFloatOrDefault(1.0f, "b", properties));
        this.a = Math.max(0.0f, this.parseFloatOrDefault(1.0f, "a", properties));
        this.useGlint = Boolean.parseBoolean(properties.getLastWithoutMetadataOrDefault("false", "citresewn", new String[]{"useGlint"}).value());
        this.blur = Boolean.parseBoolean(properties.getLastWithoutMetadataOrDefault("true", "citresewn", new String[]{"blur"}).value());
        PropertyValue blendProp = properties.getLastWithoutMetadataOrDefault("add", "citresewn", new String[]{"blend"});
        try {
            this.blend = Blend.getBlend(blendProp.value());
        }
        catch (Exception e) {
            throw new CITParsingException("Could not parse blending method", properties, blendProp.position(), (Throwable)e);
        }
        for (CITCondition condition : conditions) {
            if (!(condition instanceof ConditionEnchantments)) continue;
            ConditionEnchantments enchantments = (ConditionEnchantments)condition;
            if (this.enchantmentChecks == null && enchantments.getEnchantments().length > 0) {
                this.enchantmentChecks = new HashSet<ResourceLocation>();
            }
            this.enchantmentChecks.addAll(Arrays.asList(enchantments.getEnchantments()));
        }
    }

    private float parseFloatOrDefault(float defaultValue, String propertyName, PropertyGroup properties) throws CITParsingException {
        PropertyValue property = properties.getLastWithoutMetadata("citresewn", new String[]{propertyName});
        if (property == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(property.value());
        }
        catch (Exception e) {
            throw new CITParsingException("Could not parse float", properties, property.position(), (Throwable)e);
        }
    }

    public static enum GlintRenderLayer {
        ARMOR_ENTITY_GLINT("armor_entity_glint", 0.16f, layer -> layer.setShaderState(RenderPhaseAccessor.ARMOR_ENTITY_GLINT_SHADER()).setWriteMaskState(RenderPhaseAccessor.COLOR_MASK()).setCullState(RenderPhaseAccessor.DISABLE_CULLING()).setDepthTestState(RenderPhaseAccessor.EQUAL_DEPTH_TEST()).setLayeringState(RenderPhaseAccessor.VIEW_OFFSET_Z_LAYERING())),
        GLINT_TRANSLUCENT("glint_translucent", 8.0f, layer -> layer.setShaderState(RenderPhaseAccessor.TRANSLUCENT_GLINT_SHADER()).setWriteMaskState(RenderPhaseAccessor.COLOR_MASK()).setCullState(RenderPhaseAccessor.DISABLE_CULLING()).setDepthTestState(RenderPhaseAccessor.EQUAL_DEPTH_TEST()).setOutputState(RenderPhaseAccessor.ITEM_ENTITY_TARGET())),
        GLINT("glint", 8.0f, layer -> layer.setShaderState(RenderPhaseAccessor.GLINT_SHADER()).setWriteMaskState(RenderPhaseAccessor.COLOR_MASK()).setCullState(RenderPhaseAccessor.DISABLE_CULLING()).setDepthTestState(RenderPhaseAccessor.EQUAL_DEPTH_TEST())),
        ENTITY_GLINT("entity_glint", 0.16f, layer -> layer.setShaderState(RenderPhaseAccessor.ENTITY_GLINT_SHADER()).setWriteMaskState(RenderPhaseAccessor.COLOR_MASK()).setCullState(RenderPhaseAccessor.DISABLE_CULLING()).setDepthTestState(RenderPhaseAccessor.EQUAL_DEPTH_TEST()).setOutputState(RenderPhaseAccessor.ITEM_ENTITY_TARGET())),
        DIRECT_ENTITY_GLINT("entity_glint_direct", 0.16f, layer -> layer.setShaderState(RenderPhaseAccessor.DIRECT_ENTITY_GLINT_SHADER()).setWriteMaskState(RenderPhaseAccessor.COLOR_MASK()).setCullState(RenderPhaseAccessor.DISABLE_CULLING()).setDepthTestState(RenderPhaseAccessor.EQUAL_DEPTH_TEST()));

        public final String name;
        private final Consumer<RenderType.CompositeState.CompositeStateBuilder> setup;
        private final float scale;

        private GlintRenderLayer(String name, float scale, Consumer<RenderType.CompositeState.CompositeStateBuilder> setup) {
            this.name = name;
            this.scale = scale;
            this.setup = setup;
        }

        public RenderType build(TypeEnchantment enchantment, ResourceLocation propertiesIdentifier) {
            class Texturing
            implements Runnable {
                private final float speed;
                private final float rotation;
                private final float r;
                private final float g;
                private final float b;
                private final float a;
                private final MergeMethodIntensity methodIntensity;

                Texturing(float speed, float rotation, float r, float g, float b, float a, MergeMethodIntensity methodIntensity) {
                    this.speed = speed;
                    this.rotation = rotation;
                    this.r = r;
                    this.g = g;
                    this.b = b;
                    this.a = a;
                    this.methodIntensity = methodIntensity;
                }

                @Override
                public void run() {
                    float l = (float)Util.getMillis() * CITResewnDefaultsConfig.INSTANCE.type_enchantment_scroll_multiplier * this.speed;
                    float x = l % 110000.0f / 110000.0f;
                    float y = l % 30000.0f / 30000.0f;
                    RenderSystem.setTextureMatrix((Matrix4f)new Matrix4f().translation(-x, y, 0.0f).rotateZ(this.rotation).scale(GlintRenderLayer.this.scale));
                    RenderSystem.setShaderColor((float)this.r, (float)this.g, (float)this.b, (float)(this.a * this.methodIntensity.intensity));
                }
            }
            RenderType.CompositeState.CompositeStateBuilder layer = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(enchantment.texture, enchantment.blur, false)).setTexturingState(new RenderStateShard.TexturingStateShard("citresewn_glint_texturing", (Runnable)new Texturing(enchantment.speed, enchantment.rotation, enchantment.r, enchantment.g, enchantment.b, enchantment.a, enchantment.methodIntensity), () -> {
                RenderSystem.resetTextureMatrix();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            })).setTransparencyState((RenderStateShard.TransparencyStateShard)enchantment.blend);
            this.setup.accept(layer);
            return RenderType.create((String)("citresewn:enchantment_" + this.name + ":" + propertiesIdentifier.toString()), (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)layer.createCompositeState(false));
        }

        public VertexConsumer tryApply(VertexConsumer base, RenderType baseLayer, MultiBufferSource provider) {
            if (!TypeEnchantment.CONTAINER.apply || TypeEnchantment.CONTAINER.appliedContext == null || TypeEnchantment.CONTAINER.appliedContext.size() == 0) {
                return null;
            }
            VertexConsumer[] layers = new VertexConsumer[Math.min(TypeEnchantment.CONTAINER.appliedContext.size(), TypeEnchantment.CONTAINER.globalCap)];
            for (int i = 0; i < layers.length; ++i) {
                layers[i] = provider.getBuffer(((TypeEnchantment)TypeEnchantment.CONTAINER.appliedContext.get((int)i).type).renderLayers.get((Object)this));
            }
            provider.getBuffer(baseLayer);
            return base == null ? VertexMultiConsumer.create((VertexConsumer[])layers) : VertexMultiConsumer.create((VertexConsumer)VertexMultiConsumer.create((VertexConsumer[])layers), (VertexConsumer)base);
        }
    }

    public static class MergeMethodIntensity {
        public float intensity = 1.0f;

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum MergeMethod {
            NONE,
            AVERAGE{

                @Override
                public void applyIntensity(Map<ResourceLocation, Integer> stackEnchantments, CIT<TypeEnchantment> cit) {
                    ResourceLocation enchantment = null;
                    for (ResourceLocation enchantmentMatch : ((TypeEnchantment)cit.type).enchantmentChecks) {
                        if (!stackEnchantments.containsKey(enchantmentMatch)) continue;
                        enchantment = enchantmentMatch;
                        break;
                    }
                    if (enchantment == null) {
                        ((TypeEnchantment)cit.type).methodIntensity.intensity = 0.0f;
                    } else {
                        float sum = 0.0f;
                        for (Integer value : stackEnchantments.values()) {
                            sum += (float)value.intValue();
                        }
                        ((TypeEnchantment)cit.type).methodIntensity.intensity = (float)stackEnchantments.get(enchantment).intValue() / sum;
                    }
                }
            }
            ,
            LAYERED{

                @Override
                public void applyIntensity(Map<ResourceLocation, Integer> stackEnchantments, CIT<TypeEnchantment> cit) {
                    ResourceLocation enchantment = null;
                    for (ResourceLocation enchantmentMatch : ((TypeEnchantment)cit.type).enchantmentChecks) {
                        if (!stackEnchantments.containsKey(enchantmentMatch)) continue;
                        enchantment = enchantmentMatch;
                        break;
                    }
                    if (enchantment == null) {
                        ((TypeEnchantment)cit.type).methodIntensity.intensity = 0.0f;
                        return;
                    }
                    float max = 0.0f;
                    for (Integer value : stackEnchantments.values()) {
                        if (!((float)value.intValue() > max)) continue;
                        max = value.intValue();
                    }
                    ((TypeEnchantment)cit.type).methodIntensity.intensity = (float)stackEnchantments.get(enchantment).intValue() / max;
                }
            }
            ,
            CYCLE{

                @Override
                public void applyMethod(List<CIT<TypeEnchantment>> citEnchantments, CITContext context) {
                    ArrayList durations = new ArrayList();
                    for (CIT<TypeEnchantment> cIT : citEnchantments) {
                        durations.add(new AbstractMap.SimpleEntry<CIT<TypeEnchantment>, Float>(cIT, Float.valueOf(((TypeEnchantment)cIT.type).duration)));
                    }
                    for (Map.Entry entry : Loops.statelessFadingLoop(durations, TypeEnchantment.CONTAINER.globalFade, ticks, 20).entrySet()) {
                        ((TypeEnchantment)((CIT)entry.getKey()).type).methodIntensity.intensity = ((Float)entry.getValue()).floatValue();
                    }
                }
            };

            public static int ticks;

            public void applyIntensity(Map<ResourceLocation, Integer> stackEnchantments, CIT<TypeEnchantment> cit) {
                ((TypeEnchantment)cit.type).methodIntensity.intensity = 1.0f;
            }

            public void applyMethod(List<CIT<TypeEnchantment>> citEnchantments, CITContext context) {
                Map stackEnchantments = context.enchantments();
                for (CIT<TypeEnchantment> cit : citEnchantments) {
                    if (((TypeEnchantment)cit.type).enchantmentChecks == null) continue;
                    this.applyIntensity(stackEnchantments, cit);
                }
            }

            public static MergeMethod parse(String value) {
                return switch (value.toLowerCase(Locale.ROOT)) {
                    case "none" -> NONE;
                    case "average" -> AVERAGE;
                    case "layered" -> LAYERED;
                    case "cycle" -> CYCLE;
                    default -> throw new IllegalArgumentException("Unknown merge method");
                };
            }

            static {
                ticks = 0;
            }
        }
    }

    public static class Blend
    extends RenderStateShard.TransparencyStateShard {
        private final int src;
        private final int dst;
        private final int srcAlpha;
        private final int dstAlpha;

        private Blend(String name, int src, int dst, int srcAlpha, int dstAlpha) {
            super(name + "_glint_transparency", null, null);
            this.src = src;
            this.dst = dst;
            this.srcAlpha = srcAlpha;
            this.dstAlpha = dstAlpha;
        }

        private Blend(String name, int src, int dst) {
            this(name, src, dst, 0, 1);
        }

        public void setupRenderState() {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)this.src, (int)this.dst, (int)this.srcAlpha, (int)this.dstAlpha);
        }

        public void clearRenderState() {
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
        }

        public static Blend getBlend(String blendString) throws Exception {
            try {
                return Named.valueOf((String)blendString.toUpperCase((Locale)Locale.ENGLISH)).blend;
            }
            catch (IllegalArgumentException ignored) {
                int dstAlpha;
                int srcAlpha;
                int dst;
                int src;
                String[] split = blendString.split("\\p{Zs}+");
                if (split.length == 2) {
                    src = Blend.parseGLConstant(split[0]);
                    dst = Blend.parseGLConstant(split[1]);
                    srcAlpha = 0;
                    dstAlpha = 1;
                } else if (split.length == 4) {
                    src = Blend.parseGLConstant(split[0]);
                    dst = Blend.parseGLConstant(split[1]);
                    srcAlpha = Blend.parseGLConstant(split[2]);
                    dstAlpha = Blend.parseGLConstant(split[3]);
                } else {
                    throw new Exception();
                }
                return new Blend("custom_" + src + "_" + dst + "_" + srcAlpha + "_" + dstAlpha, src, dst, srcAlpha, dstAlpha);
            }
        }

        private static int parseGLConstant(String s) throws Exception {
            try {
                return GL11.class.getDeclaredField(s).getInt(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return s.startsWith("0x") ? Integer.parseInt(s.substring(2), 16) : Integer.parseInt(s);
            }
        }

        private static enum Named {
            REPLACE(new Blend("replace", 0, 0){

                @Override
                public void setupRenderState() {
                    RenderSystem.disableBlend();
                }
            }),
            GLINT(new Blend("glint", 768, 1)),
            ALPHA(new Blend("alpha", 770, 771)),
            ADD(new Blend("add", 770, 1)),
            SUBTRACT(new Blend("subtract", 775, 0)),
            MULTIPLY(new Blend("multiply", 774, 771)),
            DODGE(new Blend("dodge", 1, 1)),
            BURN(new Blend("burn", 0, 769)),
            SCREEN(new Blend("screen", 1, 769)),
            OVERLAY(new Blend("overlay", 774, 768));

            public final Blend blend;

            private Named(Blend blend) {
                this.blend = blend;
            }
        }
    }

    public static class Container
    extends CITTypeContainer<TypeEnchantment>
    implements CITGlobalProperties {
        public boolean globalUseGlint = true;
        public int globalCap = Integer.MAX_VALUE;
        public MergeMethodIntensity.MergeMethod globalMergeMethod = MergeMethodIntensity.MergeMethod.AVERAGE;
        public float globalFade = 0.5f;
        public List<CIT<TypeEnchantment>> loaded = new ArrayList<CIT<TypeEnchantment>>();
        public final List<List<CIT<TypeEnchantment>>> loadedLayered = new ArrayList<List<CIT<TypeEnchantment>>>();
        private List<CIT<TypeEnchantment>> appliedContext = null;
        private boolean apply = false;
        private boolean defaultGlint = false;

        public Container() {
            super(TypeEnchantment.class, TypeEnchantment::new, "enchantment");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load(List<CIT<TypeEnchantment>> parsedCITs) {
            this.loaded.addAll(parsedCITs);
            HashMap<Integer, List> layers = new HashMap<Integer, List>();
            for (CIT<TypeEnchantment> cit : this.loaded) {
                layers.computeIfAbsent(((TypeEnchantment)cit.type).layer, i -> new ArrayList()).add(cit);
            }
            Iterator<CIT<TypeEnchantment>> iterator = this.loadedLayered;
            synchronized (iterator) {
                this.loadedLayered.clear();
                layers.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(layer -> this.loadedLayered.add((List)layer.getValue()));
            }
            for (CIT<TypeEnchantment> cit : this.loaded) {
                for (GlintRenderLayer glintLayer : GlintRenderLayer.values()) {
                    RenderType renderLayer = glintLayer.build((TypeEnchantment)cit.type, cit.propertiesIdentifier);
                    ((TypeEnchantment)cit.type).renderLayers.put(glintLayer, renderLayer);
                    Minecraft.getInstance().renderBuffers().bufferSource().fixedBuffers.put(renderLayer, new ByteBufferBuilder(renderLayer.bufferSize()));
                }
            }
        }

        public void globalProperty(String key, PropertyValue value) throws Exception {
            switch (key) {
                case "useGlint": {
                    boolean bl = this.globalUseGlint = value == null ? true : Boolean.parseBoolean(value.value());
                    if (this.globalUseGlint || "false".equalsIgnoreCase(value.value())) break;
                    throw new Exception("Could not parse boolean");
                }
                case "cap": {
                    this.globalCap = value == null ? Integer.MAX_VALUE : Integer.parseInt(value.value());
                    break;
                }
                case "method": {
                    this.globalMergeMethod = value == null ? MergeMethodIntensity.MergeMethod.AVERAGE : MergeMethodIntensity.MergeMethod.parse(value.value());
                    break;
                }
                case "fade": {
                    this.globalFade = value == null ? 0.5f : Float.parseFloat(value.value());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            this.appliedContext = null;
            this.apply = false;
            for (CIT<TypeEnchantment> cit : this.loaded) {
                for (RenderType renderLayer : ((TypeEnchantment)cit.type).renderLayers.values()) {
                    Minecraft.getInstance().renderBuffers().bufferSource().fixedBuffers.remove(renderLayer);
                }
            }
            this.loaded.clear();
            List<List<CIT<TypeEnchantment>>> list = this.loadedLayered;
            synchronized (list) {
                this.loadedLayered.clear();
            }
        }

        public void apply() {
            if (this.appliedContext != null) {
                this.apply = true;
            }
        }

        public boolean shouldApply() {
            return this.apply && this.active();
        }

        public boolean shouldNotApplyDefaultGlint() {
            return !this.globalUseGlint || this.apply && !this.defaultGlint;
        }

        public Container setContext(CITContext context) {
            this.apply = false;
            this.defaultGlint = false;
            this.appliedContext = null;
            if (context == null) {
                return this;
            }
            List cits = ((CITCacheEnchantment)context.stack).citresewn$getCacheTypeEnchantment().get(context);
            this.appliedContext = new ArrayList<CIT<TypeEnchantment>>();
            if (cits != null) {
                for (WeakReference citRef : cits) {
                    if (citRef == null) continue;
                    CIT cit = (CIT)citRef.get();
                    if (this.appliedContext == null || cit == null) continue;
                    this.appliedContext.add((CIT<TypeEnchantment>)cit);
                    if (!((TypeEnchantment)cit.type).useGlint) continue;
                    this.defaultGlint = true;
                }
            }
            if (this.appliedContext != null && this.appliedContext.isEmpty()) {
                this.appliedContext = null;
            } else if (this.appliedContext != null) {
                this.globalMergeMethod.applyMethod(this.appliedContext, context);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<CIT<TypeEnchantment>> getRealTimeCIT(CITContext context) {
            List<List<CIT<TypeEnchantment>>> list = this.loadedLayered;
            synchronized (list) {
                ArrayList<CIT<TypeEnchantment>> cits = new ArrayList<CIT<TypeEnchantment>>();
                block3: for (List<CIT<TypeEnchantment>> layer : this.loadedLayered) {
                    for (CIT<TypeEnchantment> cit : layer) {
                        if (!cit.test(context)) continue;
                        cits.add(cit);
                        continue block3;
                    }
                }
                return cits;
            }
        }
    }

    public static interface CITCacheEnchantment {
        public CITCache.MultiList<TypeEnchantment> citresewn$getCacheTypeEnchantment();
    }
}

