/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.data.recipe.integration;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.mixin.accessor.MappedRegistryAccessor;
import java.util.Map;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.common.recipe.BaseRecipeBuilder;
import plus.dragons.createdragonsplus.data.recipe.integration.IntegrationResult;

public final class IntegrationResultRecipe
implements Recipe<RecipeInput> {
    private static final Map<RecipeSerializer<Recipe<?>>, Serializer> SERIALIZER_DELEGATES = Maps.newConcurrentMap();
    private final Recipe<?> delegate;
    private final IntegrationResult result;

    public IntegrationResultRecipe(Recipe<?> delegate, ItemStack delegateResult, ResourceLocation result) {
        this.delegate = delegate;
        this.result = new IntegrationResult(delegateResult, result);
    }

    public boolean matches(RecipeInput input, Level level) {
        throw new UnsupportedOperationException();
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider registries) {
        throw new UnsupportedOperationException();
    }

    public boolean canCraftInDimensions(int width, int height) {
        throw new UnsupportedOperationException();
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        throw new UnsupportedOperationException();
    }

    public RecipeSerializer<?> getSerializer() {
        RecipeSerializer delegateSerializer = this.delegate.getSerializer();
        return SERIALIZER_DELEGATES.computeIfAbsent(delegateSerializer, Serializer::new);
    }

    public RecipeType<?> getType() {
        return this.delegate.getType();
    }

    public static class Builder
    extends BaseRecipeBuilder<IntegrationResultRecipe, Builder> {
        private final BaseRecipeBuilder<?, ?> delegate;
        private final ItemStack delegateResult;
        private final ResourceLocation result;

        public Builder(BaseRecipeBuilder<?, ?> delegate, ItemStack delegateResult, ResourceLocation result) {
            super(delegate.getDirectory());
            this.delegate = delegate;
            this.delegateResult = delegateResult;
            this.result = result;
            if (delegate.getId() == null) {
                delegate.withId(result);
            }
        }

        @Override
        protected Builder builder() {
            return this;
        }

        @Override
        public RecipeHolder<IntegrationResultRecipe> build() {
            RecipeHolder<?> holder = this.delegate.build();
            return new RecipeHolder(holder.id(), (Recipe)new IntegrationResultRecipe(holder.value(), this.delegateResult, this.result));
        }

        @Override
        @Nullable
        public AdvancementHolder buildAdvancement() {
            return this.delegate.buildAdvancement();
        }

        @Override
        @Nullable
        public ResourceLocation getId() {
            return this.delegate.getId();
        }

        @Override
        @Nullable
        public String getDirectory() {
            return this.delegate.getDirectory();
        }

        @Override
        public Builder withId(ResourceLocation id) {
            this.delegate.withId(id);
            return this;
        }

        @Override
        public Builder withCondition(ICondition condition) {
            this.delegate.withCondition(condition);
            return this;
        }
    }

    static final class Serializer
    implements RecipeSerializer<IntegrationResultRecipe> {
        private static final HolderOwner<RecipeSerializer<?>> HOLDER_OWNER = new HolderOwner<RecipeSerializer<?>>(){

            public boolean canSerializeIn(HolderOwner<RecipeSerializer<?>> owner) {
                return false;
            }
        };
        private final MapCodec<IntegrationResultRecipe> codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)delegate.codec().forGetter(recipe -> recipe.delegate), (App)IntegrationResult.CODEC.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)instance, (d, result) -> {
            throw new UnsupportedOperationException("Can not decode with encode-only codec");
        }));

        Serializer(RecipeSerializer<Recipe<?>> delegate) {
            MappedRegistryAccessor registry = (MappedRegistryAccessor)BuiltInRegistries.RECIPE_SERIALIZER;
            int id = registry.getToId().getOrDefault((Object)this, -1);
            ResourceKey wrappedKey = ((Holder.Reference)registry.getByValue().get(delegate)).key();
            registry.getToId().put((Object)this, id);
            registry.getByValue().put(this, Holder.Reference.createStandAlone(HOLDER_OWNER, (ResourceKey)wrappedKey));
        }

        public MapCodec<IntegrationResultRecipe> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, IntegrationResultRecipe> streamCodec() {
            throw new UnsupportedOperationException();
        }
    }
}

