/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.item;

import java.util.List;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.bandit.many_bows.registry.ItemRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class CrimsonNexusBow
extends BowItem {
    private final WeakHashMap<Player, Long> activeLifeDrain = new WeakHashMap();

    public CrimsonNexusBow(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        Player player;
        block6: {
            block5: {
                if (!(entity instanceof Player)) break block5;
                player = (Player)entity;
                if (selected && !level.isClientSide) break block6;
            }
            return;
        }
        Long lastUsedTime = this.activeLifeDrain.get(player);
        if (lastUsedTime == null || level.getGameTime() - lastUsedTime > 60L) {
            return;
        }
        if (level.getGameTime() % 20L == 0L) {
            AttributeInstance attrInstance;
            Registry registry = level.registryAccess().registryOrThrow(Registries.ATTRIBUTE);
            Holder.Reference rangedAttrHolder = registry.getHolder(ResourceLocation.fromNamespaceAndPath((String)"ranged_weapon", (String)"damage")).orElse(null);
            float damage = rangedAttrHolder != null ? ((attrInstance = player.getAttribute((Holder)rangedAttrHolder)) != null ? (float)attrInstance.getValue() / 4.0f : 1.0f) : 1.0f;
            AABB area = new AABB(player.getX() - 10.0, player.getY() - 10.0, player.getZ() - 10.0, player.getX() + 10.0, player.getY() + 10.0, player.getZ() + 10.0);
            level.getEntities((Entity)player, area, e -> e instanceof LivingEntity && e != player).forEach(target -> {
                if (target instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)target;
                    livingEntity.hurt(player.damageSources().magic(), damage);
                    player.heal(0.25f);
                }
            });
        }
    }

    public void releaseUsing(ItemStack bowStack, Level level, LivingEntity entity, int chargeTime) {
        if (entity instanceof Player) {
            int charge;
            float power;
            Player player = (Player)entity;
            if (!level.isClientSide() && (power = CrimsonNexusBow.getPowerForTime(charge = this.getUseDuration(bowStack, entity) - chargeTime)) >= 0.1f) {
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.PLAYERS, 1.0f, 1.5f);
                float healthCost = player.getHealth() > 4.0f ? 2.0f : 0.0f;
                player.hurt(player.damageSources().magic(), healthCost);
                ItemStack arrowStack = player.getProjectile(bowStack);
                ArrowItem arrowItem = arrowStack.getItem() instanceof ArrowItem ? (ArrowItem)arrowStack.getItem() : (ArrowItem)Items.ARROW;
                AbstractArrow arrow = arrowItem.createArrow(level, arrowStack, (LivingEntity)player, bowStack);
                arrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                Holder rangedDamageAttr = level.registryAccess().registryOrThrow(Registries.ATTRIBUTE).getHolder(ResourceLocation.fromNamespaceAndPath((String)"ranged_weapon", (String)"damage")).orElse(null);
                if (rangedDamageAttr != null) {
                    AttributeInstance attrInstance = player.getAttribute(rangedDamageAttr);
                    if (attrInstance != null) {
                        float damage = (float)attrInstance.getValue();
                        arrow.setBaseDamage((double)(damage / 2.5f));
                    } else {
                        arrow.setBaseDamage(arrow.getBaseDamage() + 3.0);
                    }
                } else {
                    arrow.setBaseDamage(arrow.getBaseDamage() + 3.0);
                }
                arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, power * 3.0f, 1.0f);
                this.activeLifeDrain.put(player, level.getGameTime());
                if (player.getHealth() == player.getMaxHealth()) {
                    arrow.setCritArrow(true);
                }
                level.addFreshEntity((Entity)arrow);
                bowStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
        projectile.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot() + angle, 0.0f, velocity, inaccuracy);
    }

    public static float getPowerForTime(int pCharge) {
        float f = (float)pCharge / 16.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ARROW_ONLY;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 1;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        boolean hasArrows;
        ItemStack bowStack = player.getItemInHand(hand);
        boolean bl = hasArrows = !player.getProjectile(bowStack).isEmpty();
        if (!player.hasInfiniteMaterials() && !hasArrows) {
            return InteractionResultHolder.fail((Object)bowStack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)bowStack);
    }

    public int getDefaultProjectileRange() {
        return 64;
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is((Item)ItemRegistry.POWER_CRYSTAL.get());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.many_bows.crimson_nexus.tooltip.info").withStyle(ChatFormatting.DARK_RED));
            tooltipComponents.add((Component)Component.translatable((String)"item.many_bows.crimson_nexus.tooltip.health_cost", (Object[])new Object[]{"2.0"}).withStyle(ChatFormatting.RED));
            tooltipComponents.add((Component)Component.translatable((String)"item.many_bows.crimson_nexus.tooltip.legend").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.too_many_bows.shulker_blast_bow.hold_shift"));
        }
    }
}

