/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class WindProjectile
extends AbstractArrow {
    private static final float BASE_DAMAGE = 3.0f;
    private static final int LEVITATION_DURATION = 20;

    public WindProjectile(EntityType<? extends WindProjectile> entityType, Level level) {
        super(entityType, level);
        this.setBaseDamage(3.0);
    }

    public WindProjectile(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.WIND_PROJECTILE.get(), shooter, level, bowStack, arrowStack);
        this.setBaseDamage(3.0);
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity;
        super.onHitEntity(result);
        if (!this.level().isClientSide() && (entity = result.getEntity()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (target == this.getOwner()) {
                return;
            }
            target.hurt(this.damageSources().magic(), (float)this.getBaseDamage());
            if (!target.hasEffect(MobEffects.LEVITATION)) {
                target.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 20, 1));
            }
        }
        this.discard();
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, this.getX(), this.getY(), this.getZ(), 0.0, 0.1, 0.0);
        }
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }
}

