/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class SolarArrow
extends AbstractArrow {
    private float powerMultiplier = 1.0f;
    private boolean tornadoActive = false;
    private int tornadoTick = 0;
    private Vec3 tornadoOrigin = null;

    public void setPowerMultiplier(float power) {
        this.powerMultiplier = power;
    }

    public SolarArrow(EntityType<? extends SolarArrow> entityType, Level level) {
        super(entityType, level);
    }

    public SolarArrow(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.SOLAR_ARROW.get(), shooter, level, bowStack, arrowStack);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            return;
        }
        if (this.tornadoActive && this.tornadoOrigin != null) {
            AttributeInstance attrInstance;
            Registry registry;
            Holder.Reference rangedAttrHolder;
            LivingEntity le;
            this.setPos(this.tornadoOrigin.x, this.tornadoOrigin.y, this.tornadoOrigin.z);
            this.spawnRagingTornado((ServerLevel)this.level(), this.tornadoOrigin, this.tornadoTick);
            Entity entity2 = this.getOwner();
            LivingEntity shooter = entity2 instanceof LivingEntity ? (le = (LivingEntity)entity2) : null;
            float scaledDamage = 4.0f;
            if (shooter != null && (rangedAttrHolder = (Holder.Reference)(registry = this.level().registryAccess().registryOrThrow(Registries.ATTRIBUTE)).getHolder(ResourceLocation.fromNamespaceAndPath((String)"ranged_weapon", (String)"damage")).orElse(null)) != null && (attrInstance = shooter.getAttribute((Holder)rangedAttrHolder)) != null) {
                scaledDamage = (float)attrInstance.getValue() / 1.5f;
            }
            float finalDamage = scaledDamage * this.powerMultiplier;
            this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(3.5)).forEach(entity -> {
                if (!(entity == shooter || shooter != null && entity.isAlliedTo((Entity)shooter))) {
                    entity.setRemainingFireTicks(40);
                    entity.hurt(this.level().damageSources().magic(), finalDamage);
                }
            });
            ++this.tornadoTick;
            if (this.tornadoTick > 100) {
                this.discard();
            }
        } else if (!this.tornadoActive && this.inGround) {
            this.startTornado();
        } else if (!this.tornadoActive) {
            this.spawnAirSpiral((ServerLevel)this.level(), this.position(), this.tornadoTick);
            ++this.tornadoTick;
        }
        if (this.tornadoTick % 20 == 0) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.FIRE_AMBIENT, this.getSoundSource(), 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (!this.level().isClientSide && !this.tornadoActive) {
            this.inGround = true;
            this.startTornado();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide && !this.tornadoActive) {
            this.inGround = true;
            this.startTornado();
        }
    }

    private void startTornado() {
        this.tornadoActive = true;
        this.tornadoOrigin = this.position();
        this.setDeltaMovement(Vec3.ZERO);
        this.setNoGravity(true);
        this.setInvisible(true);
        ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY(), this.getZ(), 15, 0.3, 0.1, 0.3, 0.05);
        this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 1.0f, 1.2f);
    }

    private void spawnRagingTornado(ServerLevel level, Vec3 center, int age) {
        int height = Math.min(age, 40);
        int spiralCount = 6;
        float maxRadius = 3.5f;
        for (int y = 0; y < height; ++y) {
            float progress = (float)y / 40.0f;
            float radius = maxRadius * (0.2f + 0.8f * progress);
            double baseY = center.y + (double)y * 0.2;
            for (int i = 0; i < spiralCount; ++i) {
                double angle = (double)age * 0.25 + (double)i * (Math.PI * 2 / (double)spiralCount) + (double)y * 0.3;
                double x = center.x + Math.cos(angle) * (double)radius;
                double z = center.z + Math.sin(angle) * (double)radius;
                level.sendParticles((ParticleOptions)ParticleTypes.FLAME, x, baseY, z, 2, 0.0, 0.0, 0.0, 0.0);
                if (y % 5 == 0 && i % 2 == 0) {
                    level.sendParticles((ParticleOptions)ParticleTypes.LAVA, x, baseY, z, 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (y % 7 != 0 || i % 3 != 0) continue;
                level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, x, baseY, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void spawnAirSpiral(ServerLevel level, Vec3 center, int age) {
        float radius = 1.2f;
        int points = 20;
        for (int i = 0; i < points; ++i) {
            double angle = (double)age * 0.3 + (double)i * (Math.PI * 2 / (double)points);
            double x = center.x + Math.cos(angle) * (double)radius;
            double z = center.z + Math.sin(angle) * (double)radius;
            double y = center.y + 0.1;
            level.sendParticles((ParticleOptions)ParticleTypes.FLAME, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }
}

