/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class SentinelWrathArrow
extends AbstractArrow {
    private static final float DAMAGE_MULTIPLIER = 7.0f;
    private float powerMultiplier = 1.0f;

    public void setPowerMultiplier(float power) {
        this.powerMultiplier = power;
    }

    public SentinelWrathArrow(EntityType<? extends SentinelWrathArrow> entityType, Level level) {
        super(entityType, level);
    }

    public SentinelWrathArrow(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.SENTINEL_ARROW.get(), shooter, level, bowStack, arrowStack);
    }

    protected void onHitEntity(EntityHitResult result) {
        LivingEntity target;
        Entity entity;
        super.onHitEntity(result);
        if (!this.level().isClientSide() && (entity = result.getEntity()) instanceof LivingEntity && this.isRaidMob(target = (LivingEntity)entity)) {
            float scaledDamage;
            Entity entity2 = this.getOwner();
            if (entity2 instanceof LivingEntity) {
                AttributeInstance attrInstance;
                LivingEntity shooter = (LivingEntity)entity2;
                Registry registry = this.level().registryAccess().registryOrThrow(Registries.ATTRIBUTE);
                Holder.Reference rangedAttrHolder = registry.getHolder(ResourceLocation.fromNamespaceAndPath((String)"ranged_weapon", (String)"damage")).orElse(null);
                scaledDamage = rangedAttrHolder != null ? ((attrInstance = shooter.getAttribute((Holder)rangedAttrHolder)) != null ? (float)attrInstance.getValue() * 1.5f * this.powerMultiplier : 6.0f * this.powerMultiplier) : 6.0f * this.powerMultiplier;
            } else {
                scaledDamage = 6.0f * this.powerMultiplier;
            }
            DamageSource damageSource = this.getOwner() instanceof LivingEntity ? this.level().damageSources().arrow((AbstractArrow)this, this.getOwner()) : this.level().damageSources().arrow((AbstractArrow)this, null);
            target.hurt(damageSource, scaledDamage);
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.RAVAGER_ROAR, SoundSource.PLAYERS, 0.7f, 1.0f);
            for (int i = 0; i < 10; ++i) {
                double xOffset = (this.random.nextDouble() - 0.5) * 0.2;
                double yOffset = (this.random.nextDouble() - 0.5) * 0.2;
                double zOffset = (this.random.nextDouble() - 0.5) * 0.2;
                this.level().addParticle((ParticleOptions)ParticleTypes.CRIT, this.getX() + xOffset, this.getY() + yOffset, this.getZ() + zOffset, 0.0, 0.0, 0.0);
            }
        }
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected ItemStack getDefaultPickupItem() {
        return null;
    }

    private boolean isRaidMob(LivingEntity entity) {
        return entity instanceof Pillager || entity instanceof Vindicator || entity instanceof Evoker || entity instanceof Ravager || entity instanceof Illusioner || entity instanceof Witch;
    }
}

