/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import java.util.List;
import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class IronCladArrow
extends AbstractArrow {
    private boolean hasLanded = false;
    private int vacuumDuration = 80;

    public IronCladArrow(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public IronCladArrow(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.IRONCLAD_ARROW.get(), shooter, level, bowStack, arrowStack);
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    public void tick() {
        super.tick();
        if (this.hasLanded && this.vacuumDuration > 0) {
            AABB pullArea = new AABB(this.getX() - 5.0, this.getY() - 5.0, this.getZ() - 5.0, this.getX() + 5.0, this.getY() + 5.0, this.getZ() + 5.0);
            List nearbyEntities = this.level().getEntities((Entity)this, pullArea, e -> e instanceof LivingEntity);
            for (Entity entity : nearbyEntities) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                Vec3 arrowPos = this.position();
                Vec3 entityPos = livingEntity.position();
                Vec3 pullVector = arrowPos.subtract(entityPos).normalize().scale(0.2);
                livingEntity.setDeltaMovement(livingEntity.getDeltaMovement().add(pullVector));
            }
            --this.vacuumDuration;
            if (this.vacuumDuration <= 0) {
                this.discard();
            }
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        this.hasLanded = true;
    }
}

