/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;

public class HunterArrow
extends AbstractArrow {
    public HunterArrow(EntityType<? extends HunterArrow> entityType, Level level) {
        super(entityType, level);
    }

    public HunterArrow(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.HUNTER_ARROW.get(), shooter, level, bowStack, arrowStack);
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        if (!this.level().isClientSide && this.isPassiveMob(target) && this.getOwner() instanceof Player && (!target.isAlive() || target.isDeadOrDying())) {
            this.improveDrops(target);
        }
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected ItemStack getDefaultPickupItem() {
        return null;
    }

    private boolean isPassiveMob(LivingEntity entity) {
        EntityType t = entity.getType();
        return t == EntityType.COW || t == EntityType.PIG || t == EntityType.SHEEP || t == EntityType.CHICKEN || t == EntityType.RABBIT;
    }

    private void improveDrops(LivingEntity entity) {
        RandomSource rng = this.level().random;
        boolean cooked = entity.isOnFire();
        if (entity.getType() == EntityType.COW && entity instanceof Cow) {
            int beef = 1 + rng.nextInt(3);
            int leather = rng.nextInt(2);
            entity.spawnAtLocation(new ItemStack((ItemLike)(cooked ? Items.COOKED_BEEF : Items.BEEF), beef));
            if (leather > 0) {
                entity.spawnAtLocation(new ItemStack((ItemLike)Items.LEATHER, leather));
            }
        } else if (entity.getType() == EntityType.PIG && entity instanceof Pig) {
            int pork = 1 + rng.nextInt(3);
            entity.spawnAtLocation(new ItemStack((ItemLike)(cooked ? Items.COOKED_PORKCHOP : Items.PORKCHOP), pork));
        } else if (entity.getType() == EntityType.SHEEP && entity instanceof Sheep) {
            Block woolBlock;
            Sheep sheep = (Sheep)entity;
            int mutton = 1 + rng.nextInt(3);
            entity.spawnAtLocation(new ItemStack((ItemLike)(cooked ? Items.COOKED_MUTTON : Items.MUTTON), mutton));
            if (!sheep.isSheared() && (woolBlock = this.woolFor(sheep.getColor())) != null) {
                entity.spawnAtLocation(new ItemStack((ItemLike)woolBlock));
            }
        } else if (entity.getType() == EntityType.CHICKEN && entity instanceof Chicken) {
            int meat = 1;
            int feathers = 0 + rng.nextInt(3);
            entity.spawnAtLocation(new ItemStack((ItemLike)(cooked ? Items.COOKED_CHICKEN : Items.CHICKEN), meat));
            if (feathers > 0) {
                entity.spawnAtLocation(new ItemStack((ItemLike)Items.FEATHER, feathers));
            }
        } else if (entity.getType() == EntityType.RABBIT && entity instanceof Rabbit) {
            int meat = rng.nextInt(2) + 1;
            int hide = rng.nextInt(2);
            entity.spawnAtLocation(new ItemStack((ItemLike)(cooked ? Items.COOKED_RABBIT : Items.RABBIT), meat));
            if (hide > 0) {
                entity.spawnAtLocation(new ItemStack((ItemLike)Items.RABBIT_HIDE, hide));
            }
            if (rng.nextFloat() < 0.1f) {
                entity.spawnAtLocation(new ItemStack((ItemLike)Items.RABBIT_FOOT));
            }
        }
    }

    private Block woolFor(DyeColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_WOOL;
            case DyeColor.ORANGE -> Blocks.ORANGE_WOOL;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_WOOL;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_WOOL;
            case DyeColor.YELLOW -> Blocks.YELLOW_WOOL;
            case DyeColor.LIME -> Blocks.LIME_WOOL;
            case DyeColor.PINK -> Blocks.PINK_WOOL;
            case DyeColor.GRAY -> Blocks.GRAY_WOOL;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_WOOL;
            case DyeColor.CYAN -> Blocks.CYAN_WOOL;
            case DyeColor.PURPLE -> Blocks.PURPLE_WOOL;
            case DyeColor.BLUE -> Blocks.BLUE_WOOL;
            case DyeColor.BROWN -> Blocks.BROWN_WOOL;
            case DyeColor.GREEN -> Blocks.GREEN_WOOL;
            case DyeColor.RED -> Blocks.RED_WOOL;
            case DyeColor.BLACK -> Blocks.BLACK_WOOL;
        };
    }
}

