/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import java.util.List;
import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FrostbiteArrow
extends AbstractArrow {
    private boolean hasHit = false;
    private int hitTimer = 0;
    private final int maxHitDuration = 40;

    public FrostbiteArrow(EntityType<? extends FrostbiteArrow> entityType, Level level) {
        super(entityType, level);
    }

    public FrostbiteArrow(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.FROSTBITE_ARROW.get(), shooter, level, bowStack, arrowStack);
        this.setBaseDamage(5.0);
    }

    public void tick() {
        super.tick();
        if (this.hasHit) {
            ++this.hitTimer;
            if (this.hitTimer >= 40) {
                this.discard();
                return;
            }
        }
        if (this.level().isClientSide()) {
            double speedFactor = 0.1;
            Vec3 motion = this.getDeltaMovement();
            for (int i = 0; i < 5; ++i) {
                double xOffset = (this.random.nextDouble() - 0.5) * 0.3;
                double yOffset = (this.random.nextDouble() - 0.5) * 0.3;
                double zOffset = (this.random.nextDouble() - 0.5) * 0.3;
                this.level().addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, this.getX() + motion.x * (double)i * speedFactor, this.getY() + motion.y * (double)i * speedFactor, this.getZ() + motion.z * (double)i * speedFactor, xOffset, yOffset, zOffset);
                this.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity;
        super.onHitEntity(result);
        if (!this.level().isClientSide() && (entity = result.getEntity()) instanceof LivingEntity) {
            LivingEntity hitEntity = (LivingEntity)entity;
            hitEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 75, 5));
            this.createFrostExplosion(result.getLocation(), hitEntity);
            this.hasHit = true;
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide()) {
            this.createFrostExplosion(result.getLocation(), null);
            this.hasHit = true;
        }
    }

    private void createFrostExplosion(Vec3 position, @Nullable LivingEntity entityHit) {
        double zOffset;
        double yOffset;
        int i;
        int radius = 4;
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate((double)radius));
        for (LivingEntity entity : entities) {
            if (entity == this.getOwner() || entity == entityHit) continue;
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 75, 5));
        }
        for (i = 0; i < 100; ++i) {
            double xOffset = (this.random.nextDouble() - 0.5) * 2.0;
            yOffset = this.random.nextDouble();
            zOffset = (this.random.nextDouble() - 0.5) * 2.0;
            this.level().addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, position.x + xOffset, position.y + yOffset, position.z + zOffset, 0.0, 0.1, 0.0);
        }
        for (i = 0; i < 30; ++i) {
            double xOffset = (this.random.nextDouble() - 0.5) * 2.0;
            yOffset = this.random.nextDouble() * 0.5;
            zOffset = (this.random.nextDouble() - 0.5) * 2.0;
            this.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, position.x + xOffset, position.y + yOffset, position.z + zOffset, 0.0, 0.0, 0.0);
        }
        this.level().playSound(null, position.x, position.y, position.z, SoundEvents.GLASS_BREAK, this.getSoundSource(), 1.0f, 0.8f);
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected ItemStack getDefaultPickupItem() {
        return null;
    }
}

