/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.joml.Vector3f;

public class DragonsBreathArrow
extends AbstractArrow {
    private float powerMultiplier = 1.0f;
    private static final int PARTICLE_LIFESPAN = 40;
    private static final int MAX_LIFETIME = 100;
    private int particleTicksRemaining = 40;
    private int lifetime = 0;

    public void setPowerMultiplier(float power) {
        this.powerMultiplier = power;
    }

    public DragonsBreathArrow(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public DragonsBreathArrow(Level level, LivingEntity shooter, ItemStack bowStack, ItemStack arrowStack) {
        super((EntityType)EntityRegistry.DRAGONS_BREATH_ARROW.get(), shooter, level, bowStack, arrowStack);
        this.setBaseDamage(7.0);
    }

    protected void onHitEntity(EntityHitResult result) {
        float dotDamage;
        float scaledDamage;
        Holder.Reference rangedAttrHolder;
        super.onHitEntity(result);
        Entity entity2 = result.getEntity();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity2;
        Level level = target.level();
        level.playSound(null, target.getX(), target.getY(), target.getZ(), SoundEvents.DRAGON_FIREBALL_EXPLODE, SoundSource.PLAYERS, 1.0f, 1.0f);
        Entity entity3 = this.getOwner();
        if (entity3 instanceof LivingEntity) {
            AttributeInstance attrInstance;
            LivingEntity shooter = (LivingEntity)entity3;
            Registry registry = level.registryAccess().registryOrThrow(Registries.ATTRIBUTE);
            rangedAttrHolder = registry.getHolder(ResourceLocation.fromNamespaceAndPath((String)"ranged_weapon", (String)"damage")).orElse(null);
            scaledDamage = rangedAttrHolder != null ? ((attrInstance = shooter.getAttribute((Holder)rangedAttrHolder)) != null ? (float)attrInstance.getValue() / 1.5f : 4.0f) : 4.0f;
        } else {
            scaledDamage = 4.0f;
        }
        level.getEntities((Entity)this, target.getBoundingBox().inflate(2.0), e -> e instanceof LivingEntity).forEach(entity -> {
            LivingEntity livingEntity;
            if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity) != target) {
                livingEntity.hurt(target.damageSources().magic(), scaledDamage);
            }
        });
        rangedAttrHolder = this.getOwner();
        if (rangedAttrHolder instanceof LivingEntity) {
            AttributeInstance attrInstance;
            LivingEntity shooter = (LivingEntity)rangedAttrHolder;
            Registry registry = level.registryAccess().registryOrThrow(Registries.ATTRIBUTE);
            Holder.Reference rangedAttrHolder2 = registry.getHolder(ResourceLocation.fromNamespaceAndPath((String)"ranged_weapon", (String)"damage")).orElse(null);
            dotDamage = rangedAttrHolder2 != null ? ((attrInstance = shooter.getAttribute((Holder)rangedAttrHolder2)) != null ? (float)attrInstance.getValue() / 2.0f : 6.0f) : 6.0f;
        } else {
            dotDamage = 6.0f;
        }
        final float power = this.powerMultiplier;
        AreaEffectCloud damagingCloud = new AreaEffectCloud(this, level, target.getX(), target.getY(), target.getZ()){
            int ticksExisted;
            {
                super(level, d, e, f);
                this.ticksExisted = 0;
            }

            public void tick() {
                super.tick();
                if (++this.ticksExisted % 20 == 0 && !this.level().isClientSide) {
                    this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox()).stream().filter(e -> e != this.getOwner() && this.distanceToSqr((Entity)e) <= (double)(this.getRadius() * this.getRadius())).forEach(e -> e.hurt(this.damageSources().magic(), dotDamage * power));
                }
            }
        };
        damagingCloud.setOwner((LivingEntity)this.getOwner());
        damagingCloud.setDuration(100);
        damagingCloud.setWaitTime(10);
        damagingCloud.setRadius(3.0f);
        damagingCloud.setRadiusPerTick(-0.05f);
        damagingCloud.setParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH);
        level.addFreshEntity((Entity)damagingCloud);
        this.createImpactParticles(target.getX(), target.getY(), target.getZ());
        this.discard();
    }

    public void tick() {
        super.tick();
        ++this.lifetime;
        if (this.lifetime > 100) {
            this.discard();
            return;
        }
        if (this.level().isClientSide() && this.particleTicksRemaining > 0) {
            this.createTrailParticles();
            --this.particleTicksRemaining;
        }
    }

    private void createImpactParticles(double x, double y, double z) {
        for (int i = 0; i < 20; ++i) {
            double xOffset = (this.random.nextDouble() - 0.5) * 1.5;
            double yOffset = this.random.nextDouble() * 1.5;
            double zOffset = (this.random.nextDouble() - 0.5) * 1.5;
            this.level().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 1.0f, 0.0f), 1.0f), x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
        }
    }

    private void createTrailParticles() {
        this.level().addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, this.getX(), this.getY(), this.getZ(), 0.0, -0.05, 0.0);
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected ItemStack getDefaultPickupItem() {
        return null;
    }
}

