/*
 * Decompiled with CFR 0.152.
 */
package com.megatrex4;

import com.megatrex4.KeyBindings;
import com.megatrex4.mixin.client.PlayerInventoryAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;

@Environment(value=EnvType.CLIENT)
public class RandomBlockPlacementClient
implements ClientModInitializer {
    private static boolean randomPlacementMode = false;
    private static final Random random = new Random();
    private boolean wasRightClicking = false;
    private static final RandomBlockPlacementClient INSTANCE = new RandomBlockPlacementClient();
    private static final ResourceLocation ICON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"randomblockplacement", (String)"textures/gui/rblock.png");

    public void onInitializeClient() {
        KeyBindings.registerKeyBindings();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.player != null && client.screen == null) {
                boolean isPlacingBlock;
                boolean isRightClicking = client.options.keyUse.isDown();
                boolean bl = isPlacingBlock = isRightClicking && !this.wasRightClicking;
                if (randomPlacementMode && isPlacingBlock) {
                    this.handleBlockPlacement(client.player);
                    this.wasRightClicking = true;
                } else if (!isRightClicking) {
                    this.wasRightClicking = false;
                }
            }
        });
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            if (randomPlacementMode) {
                this.renderIcon(drawContext);
            }
        });
    }

    public static void onRandomPlaceKeyPressed() {
        randomPlacementMode = !randomPlacementMode;
    }

    public void handleBlockPlacement(LocalPlayer player) {
        if (randomPlacementMode) {
            RandomBlockPlacementClient.randomizeHotbarSlot(player);
        }
    }

    private static void randomizeHotbarSlot(LocalPlayer player) {
        int currentSlot = ((PlayerInventoryAccessor)player.getInventory()).getSelectedSlot();
        int blockCount = 0;
        int[] blockSlots = new int[9];
        for (int i = 0; i < 9; ++i) {
            if (!(player.getInventory().getItem(i).getItem() instanceof BlockItem)) continue;
            blockSlots[blockCount++] = i;
        }
        if (blockCount <= 1) {
            return;
        }
        int probability = 100 / blockCount;
        int randomValue = random.nextInt(100);
        int accumulatedProbability = 0;
        for (int i = 0; i < blockCount; ++i) {
            if (randomValue >= (accumulatedProbability += probability)) continue;
            ((PlayerInventoryAccessor)player.getInventory()).setSelectedSlot(blockSlots[i]);
            break;
        }
    }

    public static RandomBlockPlacementClient getInstance() {
        return INSTANCE;
    }

    private void renderIcon(GuiGraphics drawContext) {
        Minecraft client = Minecraft.getInstance();
        int screenWidth = client.getWindow().getGuiScaledWidth();
        int screenHeight = client.getWindow().getGuiScaledHeight();
        PoseStack matrixStack = drawContext.pose();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        matrixStack.pushPose();
        int iconSize = 16;
        int x = (screenWidth - iconSize) / 2;
        int y = (screenHeight - iconSize) / 2 - 13;
        drawContext.blit(ICON_TEXTURE, x, y, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        matrixStack.popPose();
        RenderSystem.disableBlend();
    }
}

