/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.defaultoptions.neoforge;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Collections;
import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.BalmRuntimeLoadContext;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.client.keymappings.KeyModifier;
import net.blay09.mods.balm.neoforge.NeoForgeLoadContext;
import net.blay09.mods.defaultoptions.DefaultOptions;
import net.blay09.mods.defaultoptions.PlatformBindings;
import net.blay09.mods.defaultoptions.neoforge.mixin.NeoForgeKeyMappingAccessor;
import net.minecraft.client.KeyMapping;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;

@Mod(value="defaultoptions", dist={Dist.CLIENT})
public class NeoForgeDefaultOptions {
    public NeoForgeDefaultOptions(IEventBus modEventBus) {
        PlatformBindings.INSTANCE = new PlatformBindings(this){

            @Override
            public void setDefaultKeyModifiers(KeyMapping keyMapping, Set<KeyModifier> keyModifiers) {
                KeyModifier keyModifier = keyModifiers.stream().findFirst().orElse(KeyModifier.NONE);
                net.neoforged.neoforge.client.settings.KeyModifier forgeKeyModifier = switch (keyModifier) {
                    case KeyModifier.ALT -> net.neoforged.neoforge.client.settings.KeyModifier.ALT;
                    case KeyModifier.SHIFT -> net.neoforged.neoforge.client.settings.KeyModifier.SHIFT;
                    case KeyModifier.CONTROL -> net.neoforged.neoforge.client.settings.KeyModifier.CONTROL;
                    default -> net.neoforged.neoforge.client.settings.KeyModifier.NONE;
                };
                ((NeoForgeKeyMappingAccessor)keyMapping).setKeyModifierDefault(forgeKeyModifier);
            }

            @Override
            public void setKeyModifiers(KeyMapping keyMapping, Set<KeyModifier> keyModifiers) {
                KeyModifier keyModifier = keyModifiers.stream().findFirst().orElse(KeyModifier.NONE);
                keyMapping.setKeyModifierAndCode(1.toForge(keyModifier), keyMapping.getKey());
            }

            @Override
            public InputConstants.Key getKey(KeyMapping keyMapping) {
                return keyMapping.getKey();
            }

            @Override
            public Set<KeyModifier> getKeyModifiers(KeyMapping keyMapping) {
                KeyModifier keyModifier = 1.fromForge(keyMapping.getKeyModifier());
                return keyModifier != KeyModifier.NONE ? Set.of(keyModifier) : Collections.emptySet();
            }

            @Override
            public Set<KeyModifier> getDefaultKeyModifiers(KeyMapping keyMapping) {
                KeyModifier keyModifier = 1.fromForge(keyMapping.getDefaultKeyModifier());
                return keyModifier != KeyModifier.NONE ? Set.of(keyModifier) : Collections.emptySet();
            }

            private static KeyModifier fromForge(net.neoforged.neoforge.client.settings.KeyModifier keyModifier) {
                return switch (keyModifier) {
                    default -> throw new MatchException(null, null);
                    case net.neoforged.neoforge.client.settings.KeyModifier.NONE -> KeyModifier.NONE;
                    case net.neoforged.neoforge.client.settings.KeyModifier.SHIFT -> KeyModifier.SHIFT;
                    case net.neoforged.neoforge.client.settings.KeyModifier.CONTROL -> KeyModifier.CONTROL;
                    case net.neoforged.neoforge.client.settings.KeyModifier.ALT -> KeyModifier.ALT;
                };
            }

            private static net.neoforged.neoforge.client.settings.KeyModifier toForge(KeyModifier keyModifier) {
                return switch (keyModifier) {
                    default -> throw new MatchException(null, null);
                    case KeyModifier.NONE -> net.neoforged.neoforge.client.settings.KeyModifier.NONE;
                    case KeyModifier.SHIFT -> net.neoforged.neoforge.client.settings.KeyModifier.SHIFT;
                    case KeyModifier.CONTROL -> net.neoforged.neoforge.client.settings.KeyModifier.CONTROL;
                    case KeyModifier.ALT -> net.neoforged.neoforge.client.settings.KeyModifier.ALT;
                };
            }
        };
        NeoForgeLoadContext context = new NeoForgeLoadContext(modEventBus);
        Balm.initialize((String)"defaultoptions", (BalmRuntimeLoadContext)context, () -> {});
        BalmClient.initialize((String)"defaultoptions", (BalmRuntimeLoadContext)context, DefaultOptions::initialize);
    }
}

