/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.defaultoptions.keys;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Set;
import net.blay09.mods.balm.api.client.keymappings.KeyModifier;
import net.blay09.mods.defaultoptions.PlatformBindings;
import net.minecraft.client.KeyMapping;

public record DefaultKeyMapping(InputConstants.Key input, Set<KeyModifier> modifiers) {
    public boolean matches(KeyMapping keyMapping) {
        Set<KeyModifier> keyModifiers = PlatformBindings.INSTANCE.getKeyModifiers(keyMapping);
        if (!this.modifiers.equals(keyModifiers)) {
            return false;
        }
        if (this.input.getValue() == InputConstants.UNKNOWN.getValue() && keyMapping.isUnbound()) {
            return true;
        }
        switch (this.input.getType()) {
            case KEYSYM: {
                return keyMapping.matches(this.input.getValue(), InputConstants.UNKNOWN.getValue());
            }
            case SCANCODE: {
                return keyMapping.matches(InputConstants.UNKNOWN.getValue(), this.input.getValue());
            }
            case MOUSE: {
                return keyMapping.matchesMouse(this.input.getValue());
            }
        }
        return false;
    }
}

